<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Class Delegado controladora de gestionar las preferencias del ususario con rol de Delegado
 */
class Delegado extends CI_Controller {
    private $language;
    function __construct()
    {
        parent::__construct();
        if(!$this -> session -> has_userdata('user'))
            redirect();
        $this -> language = $this -> session -> userdata ('language');
        $this -> load -> model('delegadoModel');
    }

    /**
     * Muestra la vista de preferencias del rol de delegado
     */
    public function index() {

        $data['delegado'] = $this -> delegadoModel -> getDelegado('judocupapp@gmail.com');
        $data['text_delegado'] = $this ->get_text_settings($this -> language);
        $this -> load -> view ('Estructura/header_principal');
        $this->load->view('Delegado/settings',$data);
        $this->load->view('Estructura/footer');
    }

    /**
     * Funcion para cambiar la contraseña del usuario con rol de delegado
     */
    public function modifyPassword() {
        $old_password =  $this -> input -> post ('old_password');
        $new_password =  $this -> input -> post ('new_password');
        $repeat_password =  $this -> input -> post ('repeat_password');



         if(!$this-> delegadoModel -> validatePassword('judocupapp@gmail.com',$old_password)) {
             redirect(base_url().'delegado?msg='.ERROR_OLD_PASSWORD);
         }

         $new_password != $repeat_password ? redirect(base_url().'delegado?msg='.ERROR_OLD_PASSWORD)  : $this -> delegadoModel -> setPassword(password_hash($new_password,PASSWORD_BCRYPT),'judocupapp@gmail.com');
        redirect(base_url().'delegado?msg='.SUCCESFULL_CHANGE_PASSWORD);
    }


    private function get_text_settings($language) {
        $this->lang->load('delegado_lang', $language);
        $data['delegado_text_change_password'] = $this->lang->line('delegado_text_change_password');
        $data['delegado_old_password'] = $this->lang->line('delegado_old_password');
        $data['delegado_repeat_password'] = $this->lang->line('delegado_repeat_password');
        $data['delegado_new_password'] = $this->lang->line('delegado_new_password');
        $data['email_recovery_farewell_greeting'] = $this->lang->line('email_recovery_farewell_greeting');
        $data['delegado_btn_change'] = $this->lang->line('delegado_btn_change');

        $data['delegado_name'] = $this->lang->line('delegado_name');
        $data['delegado_surname'] = $this->lang->line('delegado_surname');
        $data['delegado_second_surname'] = $this->lang->line('delegado_second_surname');
        $data['delegado_email'] = $this->lang->line('delegado_email');

        return $data;
    }


}
